#region References

using System;
using System.Collections;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using System.Text;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

#endregion

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for PatientTransfusionComment.
	/// </summary>
	public class PatientTransfusionComment  : BaseBusinessObject 
	{
		#region Variables

		private System.Data.DataRow _drCurrent;

		#endregion

		#region Constructors

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2966"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>PatientTransfusionComment object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2967"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor
		/// </summary>
		public PatientTransfusionComment(System.Data.DataRow dtRow)
		{
			System.Data.DataTable dtPtr = DAL.PatientTransfusionComment.GetEmptyPatientTransfusionCommentTable();
			this._drCurrent = dtPtr.NewRow();
			this.LoadFromDataRow(dtRow);
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2970"> 
		///		<ExpectedInput>Common.PatientTransfusionCommentCategoryCode</ExpectedInput>
		///		<ExpectedOutput>PatientTransfusionComment object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2971"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor
		/// </summary>
		public PatientTransfusionComment(Common.PatientTransfusionCommentCategoryCode category)
		{
			System.Data.DataTable dtPtr = DAL.PatientTransfusionComment.GetEmptyPatientTransfusionCommentTable();
			this._drCurrent = dtPtr.NewRow();
			this.PatientTransfusionCommentGuid = Guid.NewGuid();
			this.CommentCategoryCode = string.Concat("T", (int)category);
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2972"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>PatientTransfusionComment object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2973"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Constructor
		/// </summary>
		public PatientTransfusionComment()
		{
			System.Data.DataTable dtPtr = DAL.PatientTransfusionComment.GetEmptyPatientTransfusionCommentTable();
			this._drCurrent = dtPtr.NewRow();
			this.PatientTransfusionCommentGuid = Guid.NewGuid();
		}

		#endregion


		#region Properties

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2892"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2893"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// CannedCommentGuid
		/// </summary>
		public Guid CannedCommentGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionComment.CannedCommentGuid))
					return Guid.Empty;

				return (Guid)this._drCurrent[TABLE.PatientTransfusionComment.CannedCommentGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionComment.CannedCommentGuid] = value;
			}
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2896"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2897"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// CommentCategoryCode
		/// </summary>
		public string CommentCategoryCode
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionComment.CommentCategoryCode))
					return String.Empty;

				return this._drCurrent[TABLE.PatientTransfusionComment.CommentCategoryCode].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionComment.CommentCategoryCode] = value;
			}
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2898"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2899"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// DivisionCode
		/// </summary>
		public string DivisionCode
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionComment.DivisionCode))
					return String.Empty;

				return this._drCurrent[TABLE.PatientTransfusionComment.DivisionCode].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionComment.DivisionCode] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2924"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2925"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientTransfusionCommentGuid
		/// </summary>
		public Guid PatientTransfusionCommentGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid))
					return Guid.Empty;

				return (Guid)this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2926"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2927"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientTransfusionCommentText
		/// </summary>
		public string PatientTransfusionCommentText
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionComment.PatientTransfusionCommentText))
					return String.Empty;

				return this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionCommentText].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionCommentText] = value;
			}
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2949"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2950"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientTransfusionGuid
		/// </summary>
		public Guid PatientTransfusionGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionComment.PatientTransfusionGuid))
					return Guid.Empty;

				return (Guid)this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionGuid] = value;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2951"> 
		///		<ExpectedInput>Guid</ExpectedInput>
		///		<ExpectedOutput>Guid</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2952"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// PatientTransfusionReactionGuid
		/// </summary>
		public Guid PatientTransfusionReactionGuid
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid))
					return Guid.Empty;

				return (Guid)this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid];
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid] = value;
			}
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2953"> 
		///		<ExpectedInput>string</ExpectedInput>
		///		<ExpectedOutput>string</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2954"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// RecordStatusCode
		/// </summary>
		public string RecordStatusCode
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionComment.RecordStatusCode))
					return String.Empty;

				return this._drCurrent[TABLE.PatientTransfusionComment.RecordStatusCode].ToString();
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionComment.RecordStatusCode] = value;
			}
		}


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2964"> 
		///		<ExpectedInput>bool</ExpectedInput>
		///		<ExpectedOutput>bool</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2965"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets or sets pre-transfusion indicator
		/// </summary>
		public bool PreTransfusionIndicator
		{
			get
			{
				if (this._drCurrent.IsNull(TABLE.PatientTransfusionComment.PreTransfusionIndicator))
					return false;

				return Convert.ToBoolean(this._drCurrent[TABLE.PatientTransfusionComment.PreTransfusionIndicator]);
			}
			set
			{
				this._drCurrent[TABLE.PatientTransfusionComment.PreTransfusionIndicator] = value;
			}
		}

		#endregion



		#region Instance Methods

		#region Load Methods

		/// <summary>
		/// Load the object from the datarow parameter
		/// </summary>
		/// <param name="dtRow"></param>
		protected override void LoadFromDataRow(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.CannedCommentGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.CannedCommentGuid))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.CannedCommentGuid] = dtRow[TABLE.PatientTransfusionComment.CannedCommentGuid];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.CommentCategoryCode))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.CommentCategoryCode))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.CommentCategoryCode] = dtRow[TABLE.PatientTransfusionComment.CommentCategoryCode];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.DivisionCode))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.DivisionCode))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.DivisionCode] = dtRow[TABLE.PatientTransfusionComment.DivisionCode];
				}
			}
			
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.LastUpdateDate))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.LastUpdateDate))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.LastUpdateDate] = dtRow[TABLE.PatientTransfusionComment.LastUpdateDate];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.LastUpdateUser))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.LastUpdateUser))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.LastUpdateUser] = dtRow[TABLE.PatientTransfusionComment.LastUpdateUser];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid] = dtRow[TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.PatientTransfusionCommentText))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.PatientTransfusionCommentText))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionCommentText] = dtRow[TABLE.PatientTransfusionComment.PatientTransfusionCommentText];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.PatientTransfusionGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.PatientTransfusionGuid))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionGuid] = dtRow[TABLE.PatientTransfusionComment.PatientTransfusionGuid];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid] = dtRow[TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.RecordStatusCode))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.RecordStatusCode))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.RecordStatusCode] = dtRow[TABLE.PatientTransfusionComment.RecordStatusCode];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.RowVersion))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.RowVersion))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.RowVersion] = dtRow[TABLE.PatientTransfusionComment.RowVersion];
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.PreTransfusionIndicator))
			{
				if (!dtRow.IsNull(TABLE.PatientTransfusionComment.PreTransfusionIndicator))
				{
					this._drCurrent[TABLE.PatientTransfusionComment.PreTransfusionIndicator] = dtRow[TABLE.PatientTransfusionComment.PreTransfusionIndicator];
				}
			}

			this.IsNew = false;
			this.IsDirty = true;
		}




		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/20/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2974"> 
		///		<ExpectedInput>DataRow</ExpectedInput>
		///		<ExpectedOutput>populated DataRow</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2975"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Loads and returns a datarow with the object data
		/// </summary>
		/// <param name="dtRow"></param>
		/// <returns></returns>
		public override System.Data.DataRow LoadDataRowFromThis(System.Data.DataRow dtRow)
		{
			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.CannedCommentGuid))
			{
				dtRow[TABLE.PatientTransfusionComment.CannedCommentGuid] = this.CannedCommentGuid;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.CommentCategoryCode))
			{
				dtRow[TABLE.PatientTransfusionComment.CommentCategoryCode] = this.CommentCategoryCode;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.DivisionCode))
			{
				dtRow[TABLE.PatientTransfusionComment.DivisionCode] = this.DivisionCode;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid))
			{
				dtRow[TABLE.PatientTransfusionComment.PatientTransfusionCommentGuid] = this.PatientTransfusionCommentGuid;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.PatientTransfusionCommentText))
			{
				dtRow[TABLE.PatientTransfusionComment.PatientTransfusionCommentText] = this.PatientTransfusionCommentText;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.PatientTransfusionGuid))
			{
				dtRow[TABLE.PatientTransfusionComment.PatientTransfusionGuid] = this.PatientTransfusionGuid;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid))
			{
				dtRow[TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid] = this.PatientTransfusionReactionGuid;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.RecordStatusCode))
			{
				dtRow[TABLE.PatientTransfusionComment.RecordStatusCode] = this.RecordStatusCode;
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.RowVersion))
			{
				if (this.RowVersion == null)
				{
					dtRow[TABLE.PatientTransfusionComment.RowVersion] = DBNull.Value;
				}
				else
				{
					dtRow[TABLE.PatientTransfusionComment.RowVersion] = this.RowVersion;
				}
			}

			if (dtRow.Table.Columns.Contains(TABLE.PatientTransfusionComment.PreTransfusionIndicator))
			{
				dtRow[TABLE.PatientTransfusionComment.PreTransfusionIndicator] = this.PreTransfusionIndicator;
			}

			return(dtRow);
		}

		#endregion


		//Commented out until needed
//		/// <summary>
//		/// Save
//		/// </summary>
//		/// <param name="lastUpdateFunctionId"></param>
//		/// <returns></returns>
//		public bool Save(Common.UpdateFunction lastUpdateFunctionId)
//		{
//			bool success = false;
//
//			if (this.IsNew && this.BrokenRulesCount == 0)
//			{
//				success = DAL.PatientTransfusionComment.SaveNewPatientTransfusionComment(Common.Utility.AppendLastUpdateInformation(this._drCurrent.Table, lastUpdateFunctionId));
//			}
//			else
//			{
//				// To Do: Handle existing comments
//			}
//
//			return success;
//		}

		#endregion

		#region Static Methods


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2978"> 
		///		<ExpectedInput>Guid, Guid</ExpectedInput>
		///		<ExpectedOutput>Arraylist</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="2979"> 
		///		<ExpectedInput>Invalid guids</ExpectedInput>
		///		<ExpectedOutput>Empty Arraylist</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetComments
		/// </summary>
		/// <param name="patientTransfusionGuid"></param>
		/// <param name="patientTransfusionReactionGuid"></param>
		/// <returns></returns>
		public static ArrayList GetComments(Guid patientTransfusionGuid, Guid patientTransfusionReactionGuid)
		{
			ArrayList commentList = new ArrayList();

			DataTable comments = DAL.PatientTransfusionComment.GetComments
				(
				patientTransfusionGuid, patientTransfusionReactionGuid, Common.LogonUser.LogonUserDivisionCode
				);

			foreach (DataRow dr in comments.Rows)
			{
				commentList.Add(new PatientTransfusionComment(dr));
			}

			return commentList;
		}


		//Commented out until needed.

//		/// <summary>
//		/// SaveNewComments
//		/// </summary>
//		public static bool SaveNewComments(ArrayList commentList, Common.UpdateFunction lastUpdateFunctionId)
//		{
//			DataTable dtPatientTransfusionComment = new DataTable();
//			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.PatientTransfusionGuid, typeof(Guid));
//			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid, typeof(Guid));
//			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.CannedCommentGuid, typeof(Guid));
//			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.CommentCategoryCode, typeof(string));
//			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.PatientTransfusionCommentText, typeof(string));
//			dtPatientTransfusionComment.Columns.Add("PreTransfusionIndicator", typeof(bool));
//			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.DivisionCode, typeof(string));
//			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.RecordStatusCode, typeof(string));
//			dtPatientTransfusionComment.Columns.Add(TABLE.PatientTransfusionComment.LastUpdateUser, typeof(string));
//
//			foreach (PatientTransfusionComment comment in commentList)
//			{
//				DataRow drComment = dtPatientTransfusionComment.NewRow();
//				//
//				if (!comment.PatientTransfusionGuid.Equals(Guid.Empty))
//				{
//					drComment[TABLE.PatientTransfusionComment.PatientTransfusionGuid] = comment.PatientTransfusionGuid;
//					//Comment for unit
//					drComment["PreTransfusionIndicator"] = DBNull.Value;
//				}
//				else
//				{
//					drComment[TABLE.PatientTransfusionComment.PatientTransfusionGuid] = DBNull.Value;
//					//Comment for pre or post-transfusion
//					drComment["PreTransfusionIndicator"] = comment.PreTransfusionIndicator;
//				}
//				//
//				if (!comment.PatientTransfusionReactionGuid.Equals(Guid.Empty))
//				{
//					drComment[TABLE.PatientTransfusionComment.PatientTransfusionReactionGuid] = comment.PatientTransfusionReactionGuid;
//				}
//				else
//				{
//					drComment[TABLE.PatientTransfusionComment.PatientTransfusionGuid] = DBNull.Value;
//				}
//				//
//				if (!comment.CannedCommentGuid.Equals(Guid.Empty))
//				{
//					drComment[TABLE.PatientTransfusionComment.CannedCommentGuid] = comment.CannedCommentGuid;
//				}
//				else
//				{
//					drComment[TABLE.PatientTransfusionComment.CannedCommentGuid] = DBNull.Value;
//				}
//				//
//				drComment[TABLE.PatientTransfusionComment.CommentCategoryCode] = comment.CommentCategoryCode;
//				drComment[TABLE.PatientTransfusionComment.PatientTransfusionCommentText] = comment.PatientTransfusionCommentText;
//				drComment[TABLE.PatientTransfusionComment.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
//				drComment[TABLE.PatientTransfusionComment.RecordStatusCode] = comment.RecordStatusCode;
//				drComment[TABLE.PatientTransfusionComment.LastUpdateUser] = Common.LogonUser.LogonUserName;
//				dtPatientTransfusionComment.Rows.Add(drComment);
//			}
//
//			bool success = DAL.PatientTransfusionComment.SaveNewPatientTransfusionComment
//				(
//				Common.Utility.AppendLastUpdateInformation(dtPatientTransfusionComment, lastUpdateFunctionId)
//				);
//
//			return success;
//		}

		#endregion
	}
}
